/*
 * Decompiled with CFR 0.152.
 */
package cgcm.chestsearchbar.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonConfig {
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final List<ConfigEntry<?, ?>> CONFIG_ENTRIES = new ArrayList();

    public BooleanConfig booleanBuilder(String key, boolean def) {
        return new BooleanConfig(this, key, def);
    }

    public IntConfig intBuilder(String key, int def, int min, int max) {
        return new IntConfig(this, key, def, min, max);
    }

    public StringConfig stringBuilder(String key, String def) {
        return new StringConfig(this, key, def);
    }

    public StringListConfig stringListBuilder(String key, List<String> def) {
        return new StringListConfig(key, def);
    }

    public HashMapConfig HashMapConfigBuilder(String key, Map<String, Integer> def, int min, int max) {
        return new HashMapConfig(this, key, def, min, max);
    }

    public void load(File file) {
        if (!file.exists()) {
            this.save(file);
            return;
        }
        JsonObject json = null;
        try (FileReader reader = new FileReader(file);){
            json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (ConfigEntry<?, ?> entry : this.CONFIG_ENTRIES) {
                JsonObject entryJson;
                String key = entry.getKey();
                if (!json.has(key) || !(entryJson = json.getAsJsonObject(key)).has(key)) continue;
                entry.setValue(entryJson.get(key));
            }
        }
        catch (IOException iOException) {
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        this.checkAndSave(file, json);
    }

    private void save(File file) {
        try (FileWriter writer = new FileWriter(file);){
            this.GSON.toJson((JsonElement)this.toJson(), (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkAndSave(File file, JsonObject value) {
        JsonObject result = this.toJson();
        if (!result.equals((Object)value)) {
            try (FileWriter writer = new FileWriter(file);){
                this.GSON.toJson((JsonElement)result, (Appendable)writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (ConfigEntry<?, ?> entry : this.CONFIG_ENTRIES) {
            String key = entry.getKey();
            JsonObject entryJson = new JsonObject();
            if (entry.description != null) {
                entryJson.addProperty("description", entry.description);
            }
            entryJson.add(key, entry.getJson());
            json.add(key, (JsonElement)entryJson);
        }
        return json;
    }

    public class BooleanConfig
    extends ConfigEntry<Boolean, BooleanConfig> {
        public BooleanConfig(JsonConfig this$0, String key, Boolean defaultValue) {
            super(this$0, key, defaultValue);
        }

        @Override
        public void setValue(JsonElement value) {
            if (value.getAsJsonPrimitive().isBoolean()) {
                this.setValue(value.getAsBoolean());
            }
        }

        @Override
        public JsonElement getJson() {
            return new JsonPrimitive((Boolean)this.get());
        }
    }

    public class IntConfig
    extends ConfigEntry<Integer, IntConfig> {
        private final int min;
        private final int max;

        public IntConfig(JsonConfig this$0, String key, Integer defaultValue, int min, int max) {
            super(this$0, key, defaultValue);
            this.min = min;
            this.max = max;
        }

        @Override
        public void setValue(Integer value) {
            super.setValue(Math.max(this.min, Math.min(this.max, value)));
        }

        @Override
        public void setValue(JsonElement value) {
            if (value.getAsJsonPrimitive().isNumber()) {
                this.setValue(value.getAsInt());
            }
        }

        @Override
        public JsonElement getJson() {
            return new JsonPrimitive((Number)this.get());
        }
    }

    public class StringConfig
    extends ConfigEntry<String, StringConfig> {
        public StringConfig(JsonConfig this$0, String key, String defaultValue) {
            super(this$0, key, defaultValue);
        }

        @Override
        public void setValue(JsonElement value) {
            if (value.getAsJsonPrimitive().isString()) {
                this.setValue(value.getAsString());
            }
        }

        @Override
        public JsonElement getJson() {
            return new JsonPrimitive((String)this.get());
        }
    }

    public class StringListConfig
    extends ConfigEntry<List<String>, StringListConfig> {
        public StringListConfig(String key, List<String> defaultValue) {
            super(JsonConfig.this, key, defaultValue);
        }

        @Override
        public void setValue(JsonElement value) {
            if (value.isJsonArray()) {
                Type listType = new TypeToken<List<String>>(this){}.getType();
                List list = (List)JsonConfig.this.GSON.fromJson(value, listType);
                this.setValue(list);
            }
        }

        @Override
        public JsonElement getJson() {
            return JsonConfig.this.GSON.toJsonTree(this.get()).getAsJsonArray();
        }
    }

    public class HashMapConfig
    extends ConfigEntry<Map<String, Integer>, HashMapConfig> {
        private final int min;
        private final int max;

        public HashMapConfig(JsonConfig this$0, String key, Map<String, Integer> defaultValue, Integer min, Integer max) {
            super(this$0, key, defaultValue);
            this.min = min;
            this.max = max;
        }

        @Override
        public void setValue(JsonElement value) {
            if (value.isJsonObject()) {
                HashMap<String, Integer> map = new HashMap<String, Integer>((Map)this.get());
                for (Map.Entry entry : value.getAsJsonObject().entrySet()) {
                    if (!((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) continue;
                    map.put((String)entry.getKey(), Math.max(this.min, Math.min(this.max, ((JsonElement)entry.getValue()).getAsInt())));
                }
                this.setValue(map);
            }
        }

        @Override
        public JsonElement getJson() {
            JsonObject mapEntry = new JsonObject();
            for (Map.Entry ent : ((Map)this.get()).entrySet()) {
                mapEntry.addProperty((String)ent.getKey(), (Number)ent.getValue());
            }
            return mapEntry;
        }
    }

    public abstract class ConfigEntry<T, S extends ConfigEntry<T, S>> {
        private final String key;
        private String description;
        private T value;

        public ConfigEntry(JsonConfig this$0, String key, T defaultValue) {
            this.key = key;
            this.value = defaultValue;
            this$0.CONFIG_ENTRIES.add(this);
        }

        public S description(String description) {
            this.description = description;
            return (S)this;
        }

        public String getKey() {
            return this.key;
        }

        public T get() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public abstract void setValue(JsonElement var1);

        public abstract JsonElement getJson();
    }
}

